/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* Debug defines */

#ifndef _SCRDEBUG_H_
#define _SCRDEBUG_H_

// for ND and Best
#define     ERR_LIB                 BEST2

// allows use with MFC
#ifdef _AFXDLL
#   include "stdafx.h"
#else
#   include <mchpub.h>
#endif

#include <assert.h>

/* print to the output window in VC++ */
#if defined(_DEBUG) && defined(_DBG_PRINT)
#   if MCH_WIN == MCH_WINMSW

#       pragma warning( disable : 4142 4201 4214 4115 4514 )
#       include <windows.h>
#       include <winbase.h>
#       pragma warning( default : 4142 4201 4214 4115 )

        extern char dbgbuffer[];       // defined in seqbook.cxx
#       define DBG_PRINT(msg)               \
            OutputDebugString(msg);
#       define DBG_PRINTVAR(msg,var)        \
            sprintf(dbgbuffer, msg, var);   \
            OutputDebugString(dbgbuffer);
#   else   // MCH_WIN != MCH_WINMSW
#       define DBG_PRINT(msg)           printf( msg );
#       define DBG_PRINTVAR(msg,var)    printf( msg, var );
#   endif
#else   // _DEBUG not defined
#   define DBG_PRINT(msg)
#   define DBG_PRINTVAR(msg,var)
#endif

#define     FOREVER                 BOOL_TRUE
#define     ZERO_LEN_STR            '\x00'


#define     OUT_OF_MEMORY           0
#define     NOT_YET_IMPLEMENTED     0
#define     ILLEGAL_CASE            0

#endif
